/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import filenet.ws.utils.WSWorkflowWSDLGenerator;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;

public class WSPublishToWSRR {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.wsrr");
    protected static final String m_className = "WSPublishToWSRR";
    public static final int PUBLISH_SUCCESSFUL = 0;
    public static final int PUBLISH_ALREADY_EXIST = 1;
    private VWWorkflowSignature m_workflowSignature = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private VWSession m_session = null;
    private String m_workClassName = null;
    private boolean m_bVersionAgnostic = false;
    private String m_serverName = null;
    private int m_isolatedRegion = -1;
    private String m_serviceName = null;
    private String m_serviceDescription = null;
    private String m_timestamp = null;
    private Hashtable m_properties = null;
    static final String sTransferTimeStamp = "TransferTimeStamp";
    static final String sPEServer = "PEServer";
    static final String sIsolatedRetion = "IsolatedRegion";
    static final String sCP = "ConnectionPoint";
    static final String sFinalizedVersion = "Finalized - ";
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance();

    WSPublishToWSRR(VWSession session) throws VWException {
        String method = "WSPublishToWSRR(VWSession, VWWorkflowSignature)";
        if (session == null) {
            VWException ex = new VWException("filenet.ws.utils.nullVWSessionWSPublishToWSRR", "Null VWSession for WSPublishToWSRR");
            logger.throwing(m_className, method, ex);
        }
        this.m_session = session;
        this.m_serverName = this.m_session.getServerName();
        this.m_isolatedRegion = this.m_session.getIsolatedRegion();
    }

    WSPublishToWSRR(VWSession session, String workClassName) throws VWException {
        String method = "WSPublishToWSRR(VWSession, VWWorkflowSignature)";
        if (session == null) {
            VWException ex = new VWException("filenet.ws.utils.nullVWSessionWSPublishToWSRR", "Null VWSession for WSPublishToWSRR");
            logger.throwing(m_className, method, ex);
        }
        this.m_session = session;
        this.m_serverName = this.m_session.getServerName();
        this.m_isolatedRegion = this.m_session.getIsolatedRegion();
        this.setWorkflow(workClassName);
    }

    WSPublishToWSRR(VWSession session, VWWorkflowSignature signature) throws VWException {
        String method = "WSPublishToWSRR(VWSession, VWWorkflowSignature)";
        if (session == null) {
            VWException ex = new VWException("filenet.ws.utils.nullVWSessionWSPublishToWSRR", "Null VWSession for WSPublishToWSRR");
            logger.throwing(m_className, method, ex);
        }
        this.m_session = session;
        this.m_serverName = this.m_session.getServerName();
        this.m_isolatedRegion = this.m_session.getIsolatedRegion();
        this.setWorkflow(signature);
    }

    private void setWorkflow(String workClassName) throws VWException {
        String m_method = "setWorkflow(workClassName)";
        VWWorkflowSignature signature = this.m_session.fetchWorkflowSignature(workClassName);
        this.setWorkflow(signature);
    }

    private void setWorkflow(VWWorkflowSignature signature) throws VWException {
        String m_method = "setWorkflow(signature)";
        if (signature != null && signature.getPartnerlinkNames() != null && signature.getPartnerlinkNames().length > 0 && signature.getHasMyPortType()) {
            this.m_workflowSignature = signature;
            this.m_workClassName = this.m_workflowSignature.getName();
            this.m_bVersionAgnostic = this.m_workflowSignature.getVersionAgnostic();
            this.m_workflowDefinition = this.m_session.fetchWorkflowDefinition(this.m_workflowSignature.getWorkspaceId(), this.m_workClassName, false);
            this.m_serviceName = this.m_workClassName;
            Date transferDateTime = this.m_workflowSignature.getTransferDateTime();
            if (transferDateTime != null) {
                this.m_timestamp = this.m_dateTimeFormatter.format(transferDateTime);
            }
        } else {
            VWException ex = new VWException("filenet.ws.utils.tryingToPublishNonWSWorkflow", "Trying to publish non-WebServices workflow!");
            logger.throwing(m_className, m_method, ex);
            throw ex;
        }
        this.m_serviceDescription = this.m_serviceName + "\n" + this.m_timestamp;
        this.m_properties = new Hashtable();
        this.m_properties.put(sTransferTimeStamp, this.m_timestamp);
        this.m_properties.put(sPEServer, this.m_serverName);
        this.m_properties.put(sIsolatedRetion, String.valueOf(this.m_isolatedRegion));
        this.m_properties.put(sCP, this.m_session.getConnectionPointName());
    }

    private String getSoapAddress() throws VWException {
        return WSWorkflowWSDLGenerator.getWSDLURL(this.m_session.getConnectionPointName(), this.m_workClassName, this.m_workflowSignature.getWorkspaceId(), this.m_bVersionAgnostic);
    }

    int publish(WSWSRRRegistry wsrrRegistry) throws VWException {
        String m_method = "publish" + this.m_workflowDefinition.getName();
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        try {
            String location = this.getSoapAddress();
            String version = null;
            String namespace = null;
            String name = null;
            String encoding = null;
            WSDefinition def = null;
            Document defDoc = null;
            try {
                block23: {
                    try {
                        def = WSDefinition.getWSDefinition(this.m_session, location);
                        namespace = def.getTargetNameSpace();
                        name = this.m_workClassName;
                        encoding = def.getXMLEncoding();
                        defDoc = WSDefinition.getDocument(def.getDefinition());
                        if (this.m_bVersionAgnostic) {
                            version = sFinalizedVersion + new Integer(this.m_workflowSignature.getWorkspaceId()).toString();
                            break block23;
                        }
                        version = new Integer(this.m_workflowSignature.getWorkspaceId()).toString();
                    }
                    catch (Throwable ex) {
                        VWException vwex = new VWException(ex);
                        logger.throwing(m_className, m_method, vwex);
                        throw vwex;
                    }
                }
                Object var13_12 = null;
                if (def != null) {
                    def.releaseReferences();
                    def = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (def != null) {
                    def.releaseReferences();
                    def = null;
                }
                throw throwable;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Retrieving document");
            }
            boolean bFound = false;
            WSWSRRWsdlDocument[] docs = wsrrRegistry.retrieveWSDLDocumentByNameAndNamespace(WSDefinition.UTF8Encode(name), namespace);
            if (docs != null && docs.length > 0) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "updating document content");
                }
                for (int i = 0; i < docs.length; ++i) {
                    if (docs[i] == null || !this.isSameWebServicesWorkflow(docs[i].getLocation(), location) || !this.isExactlySameWebServiceWorkflow(docs[i], location, this.m_serverName, this.m_isolatedRegion, this.m_timestamp, defDoc)) continue;
                    bFound = true;
                }
            }
            int result = -1;
            if (!bFound) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "creating document");
                }
                String[] properties = null;
                if (this.m_properties != null && this.m_properties.size() > 0) {
                    properties = new String[this.m_properties.size() * 2];
                    Enumeration e = this.m_properties.keys();
                    int i = 0;
                    Object obj = null;
                    while (e.hasMoreElements()) {
                        obj = e.nextElement();
                        if (obj == null || !(obj instanceof String)) continue;
                        properties[i++] = obj;
                        properties[i++] = (String)this.m_properties.get(obj);
                    }
                }
                wsrrRegistry.createWSDLDocument(location, this.m_serviceName, namespace, defDoc, version, this.m_serviceDescription, encoding, properties);
                result = 0;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "document created");
                }
            } else {
                result = 1;
            }
            int n = result;
            Object var18_24 = null;
            if (logger.isFinest()) {
                logger.exiting(m_className, m_method);
            }
            return n;
        }
        catch (Throwable ex) {
            try {
                VWException vwex = new VWException(ex);
                logger.throwing(m_className, m_method, vwex);
                throw vwex;
            }
            catch (Throwable throwable) {
                block25: {
                    Object var18_25 = null;
                    if (!logger.isFinest()) break block25;
                    logger.exiting(m_className, m_method);
                }
                throw throwable;
            }
        }
    }

    private String getLocationWOVersion(String location) {
        if (location != null) {
            int index = location.indexOf("?wsdl");
            if (index != -1) {
                location = location.substring(0, index);
            }
            if ((index = location.indexOf("/wc/")) != -1 && (index = location.indexOf("/", index + 4)) != -1) {
                location = location.substring(0, index);
            }
        }
        return location;
    }

    private boolean isSameWebServicesWorkflow(String location1, String location2) {
        location1 = this.getLocationWOVersion(location1);
        location2 = this.getLocationWOVersion(location2);
        return location1 != null && location2 != null && location1.compareToIgnoreCase(location2) == 0;
    }

    private boolean isExactlySameWebServiceWorkflow(WSWSRRWsdlDocument doc, String location, String serverName, int isolatedRegion, String timestamp, Document defDoc) {
        String transferTimeStamp;
        if (doc == null || location == null || serverName == null || timestamp == null || defDoc == null) {
            return false;
        }
        if (!this.isSameWebServicesWorkflow(doc.getLocation(), location)) {
            return false;
        }
        if (location.compareToIgnoreCase(doc.getLocation()) == 0 && !this.m_bVersionAgnostic) {
            return true;
        }
        if (location.compareToIgnoreCase(doc.getLocation()) != 0 && this.m_bVersionAgnostic) {
            return false;
        }
        String server = doc.getUserDefinedProperty(sPEServer);
        if (server == null || server.compareToIgnoreCase(serverName) != 0) {
            return false;
        }
        String regionStr = doc.getUserDefinedProperty(sIsolatedRetion);
        if (regionStr != null) {
            try {
                int region = Integer.parseInt(regionStr);
                if (region != isolatedRegion) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if ((transferTimeStamp = doc.getUserDefinedProperty(sTransferTimeStamp)) == null) {
            return false;
        }
        if (transferTimeStamp.compareTo(timestamp) == 0) {
            return true;
        }
        if (!this.m_bVersionAgnostic) {
            return false;
        }
        String docVersion = doc.getVersion();
        if (docVersion != null && docVersion.startsWith(sFinalizedVersion)) {
            boolean bSame = true;
            try {
                byte[] byteArray = XMLHelper.DOMDocToUTF8ByteArray(defDoc);
                byte[] content = doc.getWSDLDocument().getContent();
                if (byteArray != null && content != null && byteArray.length == content.length) {
                    bSame = true;
                    for (int i = 0; i < byteArray.length; ++i) {
                        if (byteArray[i] == content[i]) continue;
                        bSame = false;
                    }
                }
            }
            catch (Exception ex) {
                bSame = false;
            }
            return bSame;
        }
        return false;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }
}

